/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.jsondefs;

import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONRendering;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.jsondefs.JSONVariableModifier;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.packloading.PackResourceLoader;

public abstract class AJSONMultiModelProvider
extends AJSONItem {
    @JSONParser.JSONRequired
    @JSONParser.JSONDescription(value="A list of definitions for this content.  Each definition is simply a variant of a different texture on the same model, with potentially different names/descriptions/materials/etc.  If a component uses definitions, then you will need to specify at least one, even if the component only has one variant.  Also note that anything that has a definitions section is able to be added to dynamically via a skin.")
    public List<JSONSubDefinition> definitions;
    @JSONParser.JSONDescription(value="A mapping of constant-value variable names to values.  These variables will be added into the listing of active variables the moment the JSON is loaded. Note that they CAN be over-written if referenced as such, so keep this in mind.")
    public Map<String, Double> constantValues;
    @JSONParser.JSONDescription(value="A list of variables that will be set during initial placement of this object.  These can be used to set initial states, such as open doors or lights.")
    public List<String> initialVariables;
    @JSONParser.JSONDescription(value="A listing of variable modifiers.  These may be used to modify the vehicle's physics or other variables dynamically.  If present, these values will add-on to any defined value as the base, and will modify and keep the modification for any generic variable.")
    public List<JSONVariableModifier> variableModifiers;
    @JSONParser.JSONRequired
    @JSONParser.JSONDescription(value="The rendering properties for this object.")
    public JSONRendering rendering;
    @Deprecated
    public List<String> constants;

    public String getModelLocation(JSONSubDefinition subDefinition) {
        switch (this.rendering.modelType) {
            case OBJ: {
                return PackResourceLoader.getPackResource(this, PackResourceLoader.ResourceType.OBJ_MODEL, subDefinition.modelName != null ? subDefinition.modelName : this.systemName);
            }
            case LITTLETILES: {
                return PackResourceLoader.getPackResource(this, PackResourceLoader.ResourceType.LT_MODEL, subDefinition.modelName != null ? subDefinition.modelName : this.systemName);
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    public String getTextureLocation(JSONSubDefinition subDefinition, int textureIndex) {
        switch (this.rendering.modelType) {
            case OBJ: {
                if (textureIndex > 0 && textureIndex > subDefinition.textureNames.size()) {
                    throw new IllegalArgumentException(this.packID + ":" + this.systemName + subDefinition.subName + " tried to get texture number " + (textureIndex + 1) + " for a dynamic texture, but there are only " + subDefinition.textureNames.size() + " entries in the list.  Report this to the pack author!");
                }
                return PackResourceLoader.getPackResource(this, PackResourceLoader.ResourceType.PNG, subDefinition.textureNames != null ? subDefinition.textureNames.get(textureIndex) : this.systemName + subDefinition.subName);
            }
            case LITTLETILES: {
                return "GLOBAL";
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }
}

